package com.android.print.demo;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;

import com.android.print.demo.utils.PrintUtils;
import com.mht.print.sdk.PrinterConstants;
import com.mht.print.sdk.PrinterInstance;
import com.mht.print.sdk.TsplCommand;
import com.mht.print.sdk.util.Utils;

public class UsbOperation implements IPrinterOpertion {
    private final static String TAG = "UsbOpertion";
    private Context mContext;
    private Handler mHandler;
    private PrinterInstance mPrinter;
    private UsbDevice mDevice;
    private boolean hasRegDisconnectReceiver;
    private IntentFilter filter;

    public UsbOperation(Context context, Handler handler) {
        mContext = context;
        mHandler = handler;
        hasRegDisconnectReceiver = false;

        filter = new IntentFilter();
        filter.addAction(UsbManager.ACTION_USB_DEVICE_ATTACHED);
        filter.addAction(UsbManager.ACTION_USB_DEVICE_DETACHED);
    }


    /**
     * 连接USB
     * 关于状态返回值说明，返回一个字节。
     * 第0位为纸的状态，0：无纸，1有
     * 第1位为开盖的状态：1：开盖，0，关
     * 第2位为过热：1：过热，0，无
     * 注：58小票机没有开盖传感器，仅能检测缺纸状态
     */
    @Override
    public void open(Intent data) {
        mDevice = data.getParcelableExtra(UsbManager.EXTRA_DEVICE);
        mPrinter = new PrinterInstance(mContext, mDevice, mHandler);
        mPrinter.openConnection();
        /*try {
            int retryCount = 0;
            while (retryCount < 10) {
                if (mPrinter.isConnected()) {
                    break;
                }
                Thread.sleep(1000);
                retryCount += 1;
            }
            byte[] bytes = Utils.hex2byte("1B401B401B401B61001D21111B45011B2D005BD0C2BDA85DA1A1C1F7CBAEBAC53A303037310A1B401B61021D21001B45001B2D0031383A30370A1B61001D21001B45001B2D000A1B401B61001D21111B45001B2D00BABAB1A42020202020202020202020310A1B401B61001D21111B45001B2D00BFC9C0D62020202020202020202020310A1B401B61001D21111B45001B2D00C4CCB2E82020202020202020202020310A1B64041B6402");
            mPrinter.sendByteData(bytes);
            int printerStatus = mPrinter.getPrinterStatus();
            String stateName = "查询失败";
            switch (printerStatus) {
                case PrinterConstants.State.READY:
                    stateName = "有纸";
                    break;
                case PrinterConstants.State.OUT_OF_PAPER:
                    stateName = "缺纸";
                    break;
                case PrinterConstants.State.OPEN_THE_LID:
                    stateName = "开盖";
                    break;
                default:
                    break;
            }
            String finalStateName = stateName;
            mHandler.post(() -> Toast.makeText(mContext, "打印机状态：" + finalStateName, Toast.LENGTH_SHORT).show());
            mPrinter.closeConnection();
        } catch (Exception e) {
            e.printStackTrace();
        }*/
    }

    @Override
    public void close() {
        if (mPrinter != null) {
            mPrinter.closeConnection();
            mPrinter = null;
        }
        if (hasRegDisconnectReceiver) {
            mContext.unregisterReceiver(myReceiver);
            hasRegDisconnectReceiver = false;
        }
    }

    private final BroadcastReceiver myReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            Log.i(TAG, "receiver is: " + action);
            if (UsbManager.ACTION_USB_DEVICE_ATTACHED.equals(action)) {
                // xxxxx
            } else if (UsbManager.ACTION_USB_DEVICE_DETACHED.equals(action)) {
                UsbDevice device = (UsbDevice) intent.getParcelableExtra(UsbManager.EXTRA_DEVICE);
                if (device != null && mPrinter != null
                        && mPrinter.isConnected() && device.equals(mDevice)) {
                    close();
                }
            }
        }
    };

    @Override
    public PrinterInstance getPrinter() {
        if (mPrinter != null && mPrinter.isConnected()) {
            if (!hasRegDisconnectReceiver) {
                mContext.registerReceiver(myReceiver, filter);
                hasRegDisconnectReceiver = true;
            }
        }
        return mPrinter;
    }

    @Override
    public void chooseDevice() {
        Intent intent = new Intent(mContext, UsbDeviceList.class);
        ((Activity) mContext).startActivityForResult(intent,
                MainActivity.CONNECT_DEVICE);
    }
}
